/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.global;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.Client;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.SubGuiEditBankAccess;
import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface2;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.containers.ContainerManageBanks;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiNPCManageBanks
extends GuiContainerNPCInterface2
implements IScrollData,
ICustomScrollListener,
ITextfieldListener,
IGuiData,
GuiYesNoCallback,
ISubGuiListener {
    private Bank bank = new Bank();
    private final ContainerManageBanks container;
    private final HashMap<String, Integer> data = new HashMap();
    private GuiCustomScroll scroll;
    private String selected = "";
    private int ceil = 0;
    private int waitTime = 30;
    private boolean isWait;

    public GuiNPCManageBanks(EntityNPCInterface npc, ContainerManageBanks cont) {
        super(npc, (Container)cont);
        this.drawDefaultBackground = false;
        this.setBackground("inventorymenu.png");
        this.field_147000_g = 200;
        this.container = cont;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                if (this.ceil == button.getValue()) {
                    return;
                }
                this.save();
                this.ceil = button.getValue();
                Client.sendData(EnumPacketServer.BankGet, this.bank.id, this.ceil);
                this.isWait = true;
                this.waitTime = 30;
                this.func_73866_w_();
                break;
            }
            case 1: {
                this.ceil = this.bank.ceilSettings.size();
                Client.sendData(EnumPacketServer.BankAddCeil, this.bank.id, this.ceil);
                this.isWait = true;
                this.waitTime = 30;
                this.func_73866_w_();
                break;
            }
            case 2: {
                if (!this.data.containsKey(this.selected) || !this.bank.ceilSettings.containsKey(this.ceil)) {
                    return;
                }
                String msg = new TextComponentTranslation("bank.hover.ceil.del", new Object[0]).func_150254_d();
                while (msg.contains("<br>")) {
                    msg = msg.replace("<br>", "\n");
                }
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, new TextComponentTranslation("gui.bank", new Object[]{": ID:" + this.bank.id + " \"" + this.bank.name + "\"; " + new TextComponentTranslation("gui.ceil", new Object[]{": ID:" + (this.ceil + 1)}).func_150254_d()}).func_150254_d(), msg, 1);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
            case 3: {
                this.bank.isPublic = ((GuiNpcCheckBox)button).isSelected();
                break;
            }
            case 6: {
                this.save();
                this.scroll.clear();
                StringBuilder t = new StringBuilder("New");
                while (this.data.containsKey(t.toString())) {
                    t.append("_");
                }
                this.selected = t.toString();
                Bank bank = new Bank();
                bank.name = this.selected;
                NBTTagCompound compound = new NBTTagCompound();
                bank.writeToNBT(compound);
                Client.sendData(EnumPacketServer.BankSave, compound);
                this.isWait = true;
                this.waitTime = 30;
                this.func_73866_w_();
                break;
            }
            case 7: {
                if (!this.data.containsKey(this.selected)) {
                    return;
                }
                String msg = new TextComponentTranslation("bank.hover.del", new Object[0]).func_150254_d();
                while (msg.contains("<br>")) {
                    msg = msg.replace("<br>", "\n");
                }
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, new TextComponentTranslation("gui.bank", new Object[]{": ID:" + this.bank.id + " \"" + this.bank.name + "\""}).func_150254_d(), msg, 0);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
            case 8: {
                if (this.bank == null) {
                    return;
                }
                this.setSubGui(new SubGuiEditBankAccess(0, this.bank));
            }
        }
    }

    @Override
    public void subGuiClosed(SubGuiInterface gui) {
        if (gui instanceof SubGuiEditBankAccess) {
            SubGuiEditBankAccess subGui = (SubGuiEditBankAccess)gui;
            if (this.bank.isChanging != subGui.isChanging) {
                this.bank.isChanging = subGui.isChanging;
            }
            if (!this.bank.owner.equals(subGui.owner)) {
                this.bank.owner = subGui.owner;
            }
            if (subGui.names.size() != this.bank.access.size()) {
                this.bank.access.clear();
                this.bank.access.addAll(subGui.names);
            } else {
                for (String name : subGui.names) {
                    if (this.bank.access.contains(name)) continue;
                    this.bank.access.clear();
                    this.bank.access.addAll(subGui.names);
                    break;
                }
            }
        }
    }

    public void func_73878_a(boolean result, int id) {
        NoppesUtil.openGUI((EntityPlayer)this.player, this);
        if (!result) {
            return;
        }
        switch (id) {
            case 0: {
                if (!this.data.containsKey(this.selected)) {
                    return;
                }
                Client.sendData(EnumPacketServer.BankRemove, this.data.get(this.selected), -1);
                this.isWait = true;
                this.waitTime = 30;
                this.func_73866_w_();
                break;
            }
            case 1: {
                if (!this.data.containsKey(this.selected) || !this.bank.ceilSettings.containsKey(this.ceil)) {
                    return;
                }
                Client.sendData(EnumPacketServer.BankRemove, this.data.get(this.selected), this.ceil);
                this.isWait = true;
                this.waitTime = 30;
                this.func_73866_w_();
            }
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        if (this.isWait || this.waitTime > 0 || this.subgui != null) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int slotId = 0; slotId < 2; ++slotId) {
            this.field_147002_h.func_75139_a((int)slotId).field_75223_e = this.selected.isEmpty() ? -5000 : 180;
            this.field_147002_h.func_75139_a((int)slotId).field_75221_f = this.selected.isEmpty() ? -5000 : (slotId == 0 ? 123 : 159);
            int x = this.field_147003_i + this.field_147002_h.func_75139_a((int)slotId).field_75223_e;
            int y = this.field_147009_r + this.field_147002_h.func_75139_a((int)slotId).field_75221_f;
            this.field_146297_k.func_110434_K().func_110577_a(GuiNPCInterface.RESOURCE_SLOT);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(x - 1, y - 1, 0, 0, 18, 18);
        }
        if (!this.selected.isEmpty()) {
            int x = this.field_147003_i + 5;
            int y = this.field_147009_r + 12;
            this.field_146289_q.func_78276_b(new TextComponentTranslation("gui.name", new Object[0]).func_150254_d() + ":", x, y, CustomNpcResourceListener.DefaultTextColor);
            this.field_146289_q.func_78276_b(new TextComponentTranslation("gui.ceil", new Object[0]).func_150254_d() + ":", x, y += 22, CustomNpcResourceListener.DefaultTextColor);
            this.field_146289_q.func_78276_b(new TextComponentTranslation("gui.start", new Object[0]).func_150254_d() + ":", x, y += 22, CustomNpcResourceListener.DefaultTextColor);
            this.field_146289_q.func_78276_b(new TextComponentTranslation("gui.max", new Object[0]).func_150254_d() + ":", x + 126, y, CustomNpcResourceListener.DefaultTextColor);
            x = this.field_147003_i + 179;
            y = this.field_147009_r + 112;
            this.field_146289_q.func_78276_b(new TextComponentTranslation("bank.tab.cost", new Object[0]).func_150254_d() + ":", x, y, CustomNpcResourceListener.DefaultTextColor);
            this.field_146289_q.func_78276_b(new TextComponentTranslation("bank.upg.cost", new Object[0]).func_150254_d() + ":", x, y + 36, CustomNpcResourceListener.DefaultTextColor);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.isWait || this.waitTime > 0) {
            if (!this.isWait) {
                --this.waitTime;
                if (this.waitTime == 0) {
                    this.func_73866_w_();
                }
            }
            String text = new TextComponentTranslation("gui.wait", new Object[]{": " + new TextComponentTranslation("gui.wait.data", new Object[0]).func_150254_d()}).func_150254_d();
            this.field_146289_q.func_78276_b(text, this.field_147003_i + (this.field_146294_l - this.field_146289_q.func_78256_a(text)) / 2, this.field_147009_r + 60, CustomNpcs.LableColor.getRGB());
            return;
        }
        if (this.subgui != null || !CustomNpcs.ShowDescriptions || this.selected.isEmpty()) {
            return;
        }
        int x = this.field_147003_i + 179;
        int y = this.field_147009_r + 112;
        if (this.isMouseHover(mouseX, mouseY, x, y, 60, 12)) {
            this.drawHoverText("bank.tab.cost.info", "" + this.bank.ceilSettings.get((Object)Integer.valueOf((int)this.ceil)).startCells, "" + this.bank.ceilSettings.get((Object)Integer.valueOf((int)this.ceil)).maxCells);
        } else if (this.isMouseHover(mouseX, mouseY, x, y + 36, 60, 12)) {
            this.drawHoverText("bank.upg.cost.info", "" + this.bank.ceilSettings.get((Object)Integer.valueOf((int)this.ceil)).startCells, "" + this.bank.ceilSettings.get((Object)Integer.valueOf((int)this.ceil)).maxCells);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(160, 180);
        }
        if (this.isWait || this.waitTime > 0) {
            return;
        }
        int x = this.field_147003_i + 254;
        int y = this.field_147009_r + 8;
        this.scroll.guiLeft = x;
        this.scroll.guiTop = y;
        this.addScroll(this.scroll);
        if (!this.selected.isEmpty()) {
            this.scroll.setSelected(this.selected);
        }
        List<String> list = this.scroll.getList();
        LinkedHashMap<Integer, List<String>> hts = new LinkedHashMap<Integer, List<String>>();
        if (list != null && !list.isEmpty()) {
            int i = 0;
            for (String key : list) {
                hts.put(i, Collections.singletonList("ID: " + this.data.get(key)));
                ++i;
            }
        }
        this.scroll.setHoverTexts(hts);
        GuiNpcButton button = new GuiNpcButton(6, x, y += this.scroll.field_146295_m + 2, 50, 20, "gui.add");
        button.setHoverText("bank.hover.add", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(7, x + this.scroll.field_146294_l - 50, y, 50, 20, "gui.remove");
        button.setEnabled(!this.selected.isEmpty() && this.data.size() > 1);
        button.setHoverText(new TextComponentTranslation("bank.hover.del", new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("bank.hover.change", new Object[0])).func_150254_d(), new Object[0]);
        this.addButton(button);
        x = this.field_147003_i + 75;
        y = this.field_147009_r + 8;
        GuiNpcTextField textField = new GuiNpcTextField(0, (GuiScreen)this, this.field_146289_q, x, y, 160, 16, this.selected);
        textField.func_146203_f(20);
        textField.func_146189_e(!this.selected.isEmpty());
        textField.setHoverText("bank.hover.name", new Object[0]);
        this.addTextField(textField);
        y += 22;
        ArrayList<String> csIds = new ArrayList<String>();
        if (this.bank != null) {
            for (int i = 0; i < this.bank.ceilSettings.size(); ++i) {
                csIds.add("" + (i + 1));
            }
        }
        button = new GuiButtonBiDirectional(0, x, y, 50, 20, csIds.toArray(new String[0]), this.ceil);
        button.setIsVisible(!this.selected.isEmpty());
        button.setHoverText("bank.hover.ceil", "" + this.bank.ceilSettings.size());
        this.addButton(button);
        button = new GuiNpcButton(1, x + 55, y, 50, 20, "gui.add");
        button.setIsVisible(!this.selected.isEmpty());
        button.setHoverText(new TextComponentTranslation("bank.hover.ceil.add", new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("bank.hover.change", new Object[0])).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, x + 110, y, 50, 20, "gui.remove");
        button.setIsVisible(!this.selected.isEmpty());
        button.setEnabled(this.ceil > 0);
        button.setHoverText(new TextComponentTranslation("bank.hover.ceil.add", new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("bank.hover.change", new Object[0])).func_150254_d(), new Object[0]);
        this.addButton(button);
        Bank.CeilSettings cs = this.bank.ceilSettings.get(this.ceil);
        int sc = cs.startCells;
        int mc = cs.maxCells;
        textField = new GuiNpcTextField(1, (GuiScreen)this, this.field_146289_q, x, y += 22, 50, 18, "" + sc);
        textField.func_146189_e(!this.selected.isEmpty());
        textField.setMinMaxDefault(1L, mc, sc);
        textField.setHoverText(new TextComponentTranslation("bank.hover.slots.min", new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("bank.hover.change", new Object[0])).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        textField = new GuiNpcTextField(2, (GuiScreen)this, this.field_146289_q, x + 110, y, 50, 18, "" + mc);
        textField.func_146189_e(!this.selected.isEmpty());
        textField.setMinMaxDefault(1L, 198L, mc);
        textField.setHoverText(new TextComponentTranslation("bank.hover.slots.max", new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("bank.hover.change", new Object[0])).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        button = new GuiNpcCheckBox(3, x, y += 18, 160, 16, "bank.public.true", "bank.public.false", this.bank.isPublic);
        button.setIsVisible(!this.selected.isEmpty());
        button.setHoverText("bank.hover.public", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(8, x, y + 20, 20, 20, 20, 146, GuiNPCInterface.WIDGETS);
        button.setHoverText("bank.hover.settings", new Object[0]);
        button.setIsVisible(!this.selected.isEmpty() && this.bank.isPublic);
        this.addButton(button);
        textField = new GuiNpcTextField(3, (GuiScreen)this, this.field_146289_q, x += 126, y += 52, 50, 18, "" + cs.openMoney);
        textField.func_146189_e(!this.selected.isEmpty());
        textField.setMinMaxDefault(0L, Integer.MAX_VALUE, cs.openMoney);
        textField.setHoverText("bank.hover.open.money", new Object[0]);
        this.addTextField(textField);
        textField = new GuiNpcTextField(4, (GuiScreen)this, this.field_146289_q, x, y + 36, 50, 18, "" + cs.upgradeMoney);
        textField.func_146189_e(!this.selected.isEmpty());
        textField.setMinMaxDefault(0L, Integer.MAX_VALUE, cs.upgradeMoney);
        textField.setHoverText("bank.hover.upgrade.money", new Object[0]);
        this.addTextField(textField);
    }

    @Override
    public void initPacket() {
        Client.sendData(EnumPacketServer.BanksGet, new Object[0]);
        this.isWait = false;
        this.waitTime = 30;
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 1 && this.subgui == null) {
            this.save();
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuGlobal);
            return;
        }
        super.func_73869_a(c, i);
    }

    @Override
    public void save() {
        if (this.selected != null && this.data.containsKey(this.selected) && this.bank != null && this.bank.ceilSettings.containsKey(this.ceil)) {
            this.bank.ceilSettings.get((Object)Integer.valueOf((int)this.ceil)).openStack = this.container.func_75139_a(0).func_75211_c();
            this.bank.ceilSettings.get((Object)Integer.valueOf((int)this.ceil)).upgradeStack = this.container.func_75139_a(1).func_75211_c();
            NBTTagCompound compound = new NBTTagCompound();
            this.bank.writeToNBT(compound);
            this.isWait = true;
            this.waitTime = 30;
            this.func_73866_w_();
            Client.sendData(EnumPacketServer.BankSave, compound);
        }
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (scroll.getID() == 0 && !scroll.getSelected().equals(this.selected)) {
            this.save();
            this.ceil = 0;
            this.selected = scroll.getSelected();
            Client.sendData(EnumPacketServer.BankGet, this.data.get(this.selected), 0);
            this.isWait = true;
            this.waitTime = 30;
            this.func_73866_w_();
        }
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
    }

    @Override
    public void setData(Vector<String> list, HashMap<String, Integer> dataMap) {
        this.data.clear();
        this.data.putAll(dataMap);
        this.scroll.setList(list);
        this.isWait = false;
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        if (this.bank == null) {
            this.bank = new Bank();
        }
        this.bank.readFromNBT(compound);
        if (compound.func_150297_b("CurrentCeil", 3)) {
            this.ceil = compound.func_74762_e("CurrentCeil");
        }
        this.container.setBank(this.bank, this.ceil);
        this.selected = this.bank.name;
        this.isWait = false;
    }

    @Override
    public void setSelected(String sel) {
        this.scroll.setSelected(sel);
        this.selected = this.scroll.getSelected() == null ? "" : this.scroll.getSelected();
        this.isWait = false;
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        if (this.bank.id == -1) {
            return;
        }
        switch (textField.getID()) {
            case 0: {
                String name = textField.getFullText();
                if (name.isEmpty() || this.data.containsKey(name)) break;
                String old = this.bank.name;
                this.data.remove(this.bank.name);
                this.bank.name = name;
                this.data.put(this.bank.name, this.bank.id);
                this.selected = name;
                this.scroll.replace(old, this.bank.name);
                break;
            }
            case 1: {
                if (!textField.isInteger()) {
                    textField.setFullText("" + textField.getDefault());
                    return;
                }
                this.bank.ceilSettings.get((Object)Integer.valueOf((int)this.ceil)).startCells = textField.getInteger();
                break;
            }
            case 2: {
                if (!textField.isInteger()) {
                    textField.setFullText("" + textField.getDefault());
                    return;
                }
                this.bank.ceilSettings.get((Object)Integer.valueOf((int)this.ceil)).maxCells = textField.getInteger();
                break;
            }
            case 3: {
                if (!textField.isInteger()) {
                    textField.setFullText("" + textField.getDefault());
                    return;
                }
                this.bank.ceilSettings.get((Object)Integer.valueOf((int)this.ceil)).openMoney = textField.getInteger();
                break;
            }
            case 4: {
                if (!textField.isInteger()) {
                    textField.setFullText("" + textField.getDefault());
                    return;
                }
                this.bank.ceilSettings.get((Object)Integer.valueOf((int)this.ceil)).upgradeMoney = textField.getInteger();
            }
        }
    }
}

